#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Foggy waterfallMod01.fsh  by  janeiyang   
//https://www.shadertoy.com/view/DsB3z1
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.628318  //0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Protean clouds by nimitz (twitter: @stormoid)
// https://www.shadertoy.com/view/3l23Rh
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License
// Contact the author for other licensing options

/*
	Technical details:

	The main volume noise is generated from a deformed periodic grid, which can produce
	a large range of noise-like patterns at very cheap evalutation cost. Allowing for multiple
	fetches of volume gradient computation for improved lighting.

	To further accelerate marching, since the volume is smooth, more than half the the density
	information isn't used to rendering or shading but only as an underlying volume	distance to 
	determine dynamic step size, by carefully selecting an equation	(polynomial for speed) to 
	step as a function of overall density (not necessarily rendered) the visual results can be 
	the	same as a naive implementation with ~40% increase in rendering performance.

	Since the dynamic marching step size is even less uniform due to steps not being rendered at all
	the fog is evaluated as the difference of the fog integral at each rendered step.

*/

mat2 rot(in float a){float c = cos(a), s = sin(a);return mat2(c,s,-s,c);}
//const mat3 m3 = mat3( -0.4480736, -0.8939967, -0.0000000,\
//  -0.4005763,  0.2007700, -0.8939967,\
//   0.7992300, -0.4005763, -0.4480736 ) *1.5f;

const mat3 m3 = mat3( -0.0, -1.0, -0.0000000,\
  -0.0,  0.1250, 1.0,\
   -1.0, 0.0, -0.0 ) *1.5f;
float mag2(vec2 p){return dot(p,p);}
float linstep(in float mn, in float mx, in float x){ return clamp((x - mn)/(mx - mn), 0., 1.); }
float prm1 = 0.;
vec2 bsMo = vec2(0);

vec2 disp(float t){ return vec2(0.0f, 0.0f); }

float sdBox( vec3 p, vec3 b )
{
  vec3 q = abs(p) - b;
  return length(max(q,0.0)) + min(max(q.x,max(q.y,q.z)),0.0);
}

float sdSphere( vec3 p, float s )
{
  return length(p)-s;
}

float sdCurvePlane(vec3 p, float h)
{
    if(dot(p.xz, vec2(0.0f, 1.0)) >= 0.0) 
    {
        return p.y * h - length(p.xz);
    }
    else
    {
        return 100000.0f;
    }
}

float opSmoothSubtraction( float d1, float d2, float k ) 
{
    float h = clamp( 0.5 - 0.5*(d2+d1)/k, 0.0, 1.0 );
    return mix( d2, -d1, h ) + k*h*(1.0-h); 
}


float opUnion( float d1, float d2 ) { return min(d1,d2); }

float opSubtraction( float d1, float d2 ) { return max(-d1,d2); }

float opIntersection( float d1, float d2 ) { return max(d1,d2); }


float opSmoothUnion( float d1, float d2, float k ) 
{
    float h = clamp( 0.5 + 0.5*(d2-d1)/k, 0.0, 1.0 );
    return mix( d2, d1, h ) - k*h*(1.0-h); 
}


float scene(vec3 p)
{
    float sphereD1 = sdSphere(p-vec3(8.5f, 1.0f, 19.0f),11.0f);
    float sphereD2 = sdSphere(p-vec3(6.5f, -3.0f, 7.0f), 8.0f);
    float sphereD3 = sdSphere(p-vec3(-7.0f, -5.0f, 11.0f), 10.0f);
    float sphereD4 = sdSphere(p-vec3(9.5f, 4.0f, 36.0f), 24.0f);
    float sphereD5 = sdSphere(p-vec3(-12.0f, -1.0f, 26.0f), 17.0f);
    float sphereD6 = sdSphere(p-vec3(0.0f, 0.0f, 1.0f), 4.0f);
    float sphereD7 = sdSphere(p-vec3(15.5f, 4.0f, 34.0f), 24.0f);
    //return opSmoothSubtraction(sphereD2, sphereD1, 1.0f);
    //return sphereD2;
    //return opUnion(sphereD1, sphereD2);
    float curvePlaneD = sdCurvePlane(p - vec3(0.0f, -3.0f, 7.0f), 2.0f);
    float smooth1 = 0.5f;
    return opSmoothUnion(opSmoothUnion(opSmoothUnion(opSmoothUnion(opSmoothUnion(opSmoothUnion(opSmoothUnion(curvePlaneD, sphereD2, smooth1), sphereD1, smooth1), sphereD3, smooth1), sphereD4, smooth1), sphereD5, smooth1), sphereD6, smooth1), sphereD7, smooth1);
    //return curvePlaneD;
}

float sceneSmooth(vec3 p)
{
    float sphereD1 = sdSphere(p-vec3(6.5f, 1.0f, 19.0f),9.0f);
    float sphereD2 = sdSphere(p-vec3(10.f, -1.0f, 12.0f), 9.0f);
    float sphereD3 = sdSphere(p-vec3(-7.0f, -5.0f, 11.0f), 10.0f);
    float sphereD4 = sdSphere(p-vec3(9.5f, 4.0f, 36.0f), 24.0f);
    float sphereD5 = sdSphere(p-vec3(-12.0f, -1.0f, 26.0f), 17.0f);
    float sphereD6 = sdSphere(p-vec3(0.0f, 0.0f, 1.0f), 4.0f);
    float sphereD7 = sdSphere(p-vec3(15.5f, 4.0f, 34.0f), 24.0f);
    //return opSmoothSubtraction(sphereD2, sphereD1, 1.0f);
    //return sphereD2;
    //return opUnion(sphereD1, sphereD2);
    float curvePlaneD = sdCurvePlane(p - vec3(0.0f, -3.0f, 100.0f), 2.0f);
    return opUnion(opUnion(opUnion(opUnion(opUnion(opUnion(opUnion(curvePlaneD, sphereD2), sphereD1), sphereD3), sphereD4), sphereD5), sphereD6), sphereD7);
    //return curvePlaneD;
}



vec2 map(vec3 p)
{
    vec3 p2 = p;
    //p2.xy -= disp(p.z).xy;
    p.yz *= -rot(iTime*0.1);
    //p.xyz -= normalize(p.xyz) * iTime * 0.00001f;
    //float cl = 4.0f - mag2(p2.xy);
    float cl = scene(p2 - vec3(4.0f, 0.0f, 0.0f));
    float d = 0.;
    p *= 0.88;
    float z = 1.;
    float trk = 1.;
    float dspAmp = 0.2 + prm1*0.02;
    for(int i = 0; i < 5; i++)
    {
        //p -= normalize(p) * fract(iTime * .00001f) * dspAmp;
        p += cos(p.zyx*0.75*trk + iTime*trk*0.8)*dspAmp;
        d -= abs(dot(cos(p), sin(p.yzx * 0.8f))*z);
        z *= 0.57;
        trk *= 1.05;
        p = p*m3;
    }
    d = abs(d);
    return vec2( d*0.5 + cl + 0.25, cl);
    //return vec2(cl, cl);
}

vec4 render( in vec3 ro, in vec3 rd, float time )
{
	vec4 rez = vec4(0);

	float t = 1.5f;
	float fogT = 0.;
	for(int i=0; i<120; i++)
	{
		if(rez.a > 0.99)break;

		vec3 pos = ro + t*rd;
        vec2 mpv = map(pos);
		float den = clamp(-mpv.x - 2.1, 0., 1.) * 1.5;
        
		vec4 col = vec4(0);
        if (mpv.x < 10.0)
        {
        
            col = vec4(sin(vec3(0.5,0.6,0.8))*2.0 ,0.02);
            col *= den*den*den;
			col.rgb *= linstep(4.,-2.5, -mpv.x)*clamp((0.8 + (1.0f - clamp(length(pos - vec3(2.0f, 2.0f, 7.0f)) / 20.0f, 0.0f, 1.0f)) * 6.0f), 0.0f, 3.0f);
            col.xyz *= den*(vec3(0.025,.025,.025));
        }
		
		float fogC = exp(t*0.2 - 2.2);
		col.rgba += vec4(0.06,0.07,0.08, 0.1)*clamp(fogC-fogT, 0., 1.);
		fogT = fogC;
		rez = rez + col*(1. - rez.a);
		t += clamp(0.1 + clamp(mpv.y + 3.0f, 0.0f, 10000.0f), 0.01, 0.3);
	}
	return clamp(rez, 0.0, 1.0);
}

float getsat(vec3 c)
{
    float mi = min(min(c.x, c.y), c.z);
    float ma = max(max(c.x, c.y), c.z);
    return (ma - mi)/(ma+ 1e-7);
}

//from my "Will it blend" shader (https://www.shadertoy.com/view/lsdGzN)
vec3 iLerp(in vec3 a, in vec3 b, in float x)
{
    vec3 ic = mix(a, b, x) + vec3(1e-6,0.,0.);
    float sd = abs(getsat(ic) - mix(getsat(a), getsat(b), x));
    vec3 dir = normalize(vec3(2.*ic.x - ic.y - ic.z, 2.*ic.y - ic.x - ic.z, 2.*ic.z - ic.y - ic.x));
    float lgt = dot(vec3(1.0), ic);
    float ff = dot(dir, normalize(ic));
    ic += 1.5*dir*sd*ff*lgt;
    return clamp(ic,0.,1.);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 	
	vec2 q = fragCoord.xy/iResolution.xy;
    vec2 p = (gl_FragCoord.xy - 0.5*iResolution.xy)/iResolution.y;
    bsMo = (iMouse.xy - 0.5*iResolution.xy)/iResolution.y;
    
    float time = iTime*3.;
    vec3 ro = vec3(0,0,0);
    
        
    float dspAmp = .85;
    float tgtDst = 3.5;
    
    vec3 target = normalize(ro - vec3(0,0, time + tgtDst));
    ro.x -= bsMo.x*4.;
    vec3 rightdir = normalize(cross(target, vec3(0,1,0)));
    vec3 updir = normalize(cross(rightdir, target));
    rightdir = normalize(cross(updir, target));
	vec3 rd=normalize((p.x*rightdir + p.y*updir)*1. - target);
    prm1 = smoothstep(-0.4, 0.4,sin(iTime*0.3));
	vec4 scn = render(ro, rd, time);
		
    vec3 col = scn.rgb;
    //col = iLerp(col.bgr, col.rgb, clamp(1.-prm1,0.05,1.));
    
    col = pow(col, vec3(.65,0.65,0.65))*vec3(1.,.97,.97);

    col *= pow( 16.0*q.x*q.y*(1.0-q.x)*(1.0-q.y), 0.12)*0.7+0.3; //Vign
    
	fragColor = vec4( col, 1.0 );
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

